<?php
// includes/mail.php - plantilla para enviar emails con PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/../vendor/autoload.php';

function sendEmail($to, $subject, $bodyHtml) {
    $cfg = require __DIR__ . '/../config.php';
    $mail = new PHPMailer(true);
    try {
        // Configuración SMTP - usar variables de entorno en producción
        $mail->isSMTP();
        $mail->Host = getenv('SMTP_HOST') ?: 'smtp.example.com';
        $mail->SMTPAuth = true;
        $mail->Username = getenv('SMTP_USER') ?: 'user@example.com';
        $mail->Password = getenv('SMTP_PASS') ?: 'secret';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        $mail->setFrom($cfg['mail']['from_email'], $cfg['mail']['from_name']);
        $mail->addAddress($to);
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $bodyHtml;
        $mail->AltBody = strip_tags($bodyHtml);

        $mail->send();
        return true;
    } catch (Exception $e) {
        // logear $mail->ErrorInfo
        return false;
    }
}
