<?php
// includes/sonicpanel.php - wrapper básico para SonicPanel API
class SonicPanel {
    private $apiUrl;
    private $apiKey;
    private $apiUser;

    public function __construct($config) {
        $this->apiUrl = rtrim($config['api_url'], '/');
        $this->apiKey = $config['api_key'];
        $this->apiUser = $config['api_user'];
    }

    private function request($path, $data = [], $method = 'POST') {
        $url = $this->apiUrl . $path;
        $headers = [
            'Accept: application/json',
            'Content-Type: application/json',
            'X-API-KEY: ' . $this->apiKey,
            'X-API-USER: ' . $this->apiUser
        ];

        $ch = curl_init();
        if ($method === 'GET' && !empty($data)) {
            $url .= '?' . http_build_query($data);
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        if ($method !== 'GET') {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
        $resp = curl_exec($ch);
        if ($resp === false) {
            $err = curl_error($ch);
            curl_close($ch);
            throw new Exception('Curl error: ' . $err);
        }
        curl_close($ch);
        return json_decode($resp, true);
    }

    public function createService($email, $package, $password) {
        $payload = [
            'email' => $email,
            'package' => $package,
            'password' => $password
        ];
        return $this->request('/services/create', $payload, 'POST');
    }

    public function suspendService($serviceId) {
        return $this->request('/services/suspend', ['id' => $serviceId], 'POST');
    }

    public function getService($serviceId) {
        return $this->request('/services/get', ['id' => $serviceId], 'GET');
    }
}
